% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_envvars.R
\name{tar_envvars}
\alias{tar_envvars}
\title{Show \code{targets} environment variables.}
\usage{
tar_envvars(unset = "")
}
\arguments{
\item{unset}{Character of length 1, value to return
for any environment variable that is not set.}
}
\value{
A data frame with one row per environment variable
and columns with the name and current value of each.
An unset environment variable will have a value of \code{""}
by default. (Customize with the \code{unset} argument).
}
\description{
Show all the special environment variables
available for customizing \code{targets}.
}
\details{
You can customize the behavior of \code{targets}
with special environment variables. The sections in this help file
describe each environment variable, and the \code{tar_envvars()} function
lists their current values.

If you modify environment variables, please set them
in project-level \code{.Renviron} file so you do not lose your
configuration when you restart your R session.
Modify the project-level \code{.Renviron} file with
\code{usethis::edit_r_environ(scope = "project")}. Restart
your R session after you are done editing.

For targets that run on parallel workers
created by \code{\link[=tar_make_clustermq]{tar_make_clustermq()}} or \code{\link[=tar_make_future]{tar_make_future()}},
only the environment variables listed by \code{\link[=tar_envvars]{tar_envvars()}}
are specifically exported to the targets.
For all other environment variables, you will have to set
the values manually, e.g. a project-level \code{.Renviron} file
(for workers that have access to the local file system).
}
\section{TAR_ASK}{

The \code{TAR_ASK} environment variable accepts values \code{"true"} and \code{"false"}.
If \code{TAR_ASK} is not set, or if it is set to \code{"true"},
then \code{targets} asks permission in a menu
before overwriting certain files, such as the target script file
(default: \verb{_targets.R}) in \code{\link[=tar_script]{tar_script()}}.
If \code{TAR_ASK} is \code{"false"}, then \code{targets} overwrites the old files
with the new ones without asking. Once you are comfortable with
\code{\link[=tar_script]{tar_script()}}, \code{\link[=tar_github_actions]{tar_github_actions()}}, and similar functions,
you can safely set \code{TAR_ASK} to \code{"false"} in either a project-level
or user-level \code{.Renviron} file.
}

\section{TAR_CONFIG}{

The \code{TAR_CONFIG} environment variable controls the file path to the
optional YAML configuration file with project settings.
See the help file of \code{\link[=tar_config_set]{tar_config_set()}} for details.
}

\section{TAR_PROJECT}{

The \code{TAR_PROJECT} environment variable sets the name of project
to set and get settings when working with the YAML configuration file.
See the help file of \code{\link[=tar_config_set]{tar_config_set()}} for details.
}

\section{TAR_WARN}{

The \code{TAR_WARN} environment variable accepts values \code{"true"} and \code{"false"}.
If \code{TAR_WARN} is not set, or if it is set to \code{"true"},
then \code{targets} throws warnings in certain edge cases,
such as target/global name conflicts and dangerous use of
\code{devtools::load_all()}. If \code{TAR_WARN} is \code{"false"}, then \code{targets}
does not throw warnings in these cases.
These warnings can detect potentially serious
issues with your pipeline, so please do not set \code{TAR_WARN}
unless your use case absolutely requires it.
}

\examples{
tar_envvars()
}
\seealso{
Other configuration: 
\code{\link{tar_config_get}()},
\code{\link{tar_config_projects}()},
\code{\link{tar_config_set}()},
\code{\link{tar_config_unset}()},
\code{\link{tar_config_yaml}()},
\code{\link{tar_option_get}()},
\code{\link{tar_option_reset}()},
\code{\link{tar_option_set}()}
}
\concept{configuration}
