% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_resources_aws.R
\name{tar_resources_aws}
\alias{tar_resources_aws}
\title{Target resources: AWS storage formats}
\usage{
tar_resources_aws(bucket, prefix = targets::path_objects_dir_cloud())
}
\arguments{
\item{bucket}{Character of length 1, name of an existing
AWS S3 bucket to upload and download the return values
of the affected targets during the pipeline.}

\item{prefix}{Character of length 1, "directory path"
in the S3 bucket where the target return values are stored.}
}
\value{
Object of class \code{"tar_resources_aws"}, to be supplied
to the \code{aws} argument of \code{tar_resources()}.
}
\description{
Create the \code{aws} argument of \code{tar_resources()}
to specify optional settings to AWS storage formats.
See the \code{format} argument of \code{\link[=tar_target]{tar_target()}} for details.
}
\section{Resources}{

Functions \code{\link[=tar_target]{tar_target()}} and \code{\link[=tar_option_set]{tar_option_set()}}
each takes an optional \code{resources} argument to supply
non-default settings of various optional backends for data storage
and high-performance computing. The \code{tar_resources()} function
is a helper to supply those settings in the correct manner.
Resources are all-or-nothing: if you specify any resources
with \code{\link[=tar_target]{tar_target()}}, all the resources from \code{tar_option_get("resources")}
are dropped for that target. In other words, if you write
\code{tar_option_set(resources = resources_1)} and then
\code{tar_target(x, my_command(), resources = resources_2)}, then everything
in \code{resources_1} is discarded for target \code{x}.
}

\examples{
# Somewhere in you target script file (usually _targets.R):
tar_target(
  name,
  command(),
  format = "aws_qs",
  resources = tar_resources(
    aws = tar_resources_aws(bucket = "yourbucketname"),
    qs = tar_resources_qs(preset = "fast")
  )
)
}
\seealso{
Other resources: 
\code{\link{tar_resources_clustermq}()},
\code{\link{tar_resources_feather}()},
\code{\link{tar_resources_fst}()},
\code{\link{tar_resources_future}()},
\code{\link{tar_resources_parquet}()},
\code{\link{tar_resources_qs}()},
\code{\link{tar_resources_url}()},
\code{\link{tar_resources}()}
}
\concept{resources}
