% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_prune.R
\name{tar_prune}
\alias{tar_prune}
\title{Remove targets that are no longer part of the pipeline.}
\usage{
tar_prune(
  callr_function = callr::r,
  callr_arguments = targets::callr_args_default(callr_function)
)
}
\arguments{
\item{callr_function}{A function from \code{callr} to start a fresh clean R
process to do the work. Set to \code{NULL} to run in the current session
instead of an external process (but restart your R session just before
you do in order to clear debris out of the global environment).
\code{callr_function} needs to be \code{NULL} for interactive debugging,
e.g. \code{tar_option_set(debug = "your_target")}.
However, \code{callr_function} should not be \code{NULL} for serious
reproducible work.}

\item{callr_arguments}{A list of arguments to \code{callr_function}.}
}
\value{
\code{NULL} except if \code{callr_function = callr::r_bg()}, in which case
a handle to the \code{callr} background process is returned. Either way,
the value is invisibly returned.
}
\description{
Remove target values from \verb{_targets/objects/} and
target metadata from \verb{_targets/meta/meta} for targets that are no longer
part of the pipeline. Global objects and dynamic files outside the
data store are unaffected. Also removes \verb{_targets/scratch/},
which is only needed while \code{\link[=tar_make]{tar_make()}}, \code{\link[=tar_make_clustermq]{tar_make_clustermq()}},
or \code{\link[=tar_make_future]{tar_make_future()}} is running.
}
\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  list(
    tar_target(y1, 1 + 1),
    tar_target(y2, 1 + 1),
    tar_target(z, y1 + y2)
  )
}, ask = FALSE)
tar_make()
# Remove some targets from the pipeline.
tar_script(list(tar_target(y1, 1 + 1)), ask = FALSE)
# Keep only the remaining targets in the data store.
tar_prune()
})
}
}
