% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_pattern.R
\name{tar_pattern}
\alias{tar_pattern}
\alias{map}
\alias{cross}
\alias{head}
\alias{tail}
\alias{sample}
\title{Emulate dynamic branching.}
\usage{
tar_pattern(pattern, ..., seed = 0L)
}
\arguments{
\item{pattern}{Function call with the pattern specification.}

\item{...}{Named integers, each of length 1.
Each name is the name of a dependency target,
and each integer is the length of the target
(number of branches or slices). Names must be unique.}

\item{seed}{Integer of length 1, random number generator seed to
emulate the pattern reproducibly. (The \code{sample()} pattern is random).
In a real pipeline, the seed is automatically generated
from the target name in deterministic fashion.}
}
\value{
A \code{tibble} showing the kinds of dynamic branches that
\code{\link[=tar_target]{tar_target()}} would create in a real pipeline with the given \code{pattern}.
Each row is a dynamic branch, each column is a dependency target,
and each element is the name of an upstream bud or branch that the
downstream branch depends on. Buds are pieces of non-branching targets
("stems") and branches are pieces of patterns. The returned bud and branch
names are not the actual ones you will see when you run the pipeline,
but they do communicate the branching structure of the pattern.
}
\description{
Emulate the dynamic branching process outside a pipeline.
\code{tar_pattern()} can help you understand the overall branching structure
that comes from the \code{pattern} argument of \code{\link[=tar_target]{tar_target()}}.
}
\details{
Dynamic branching is a way to programmatically
create multiple new targets based on the values of other targets,
all while the pipeline is running. Use the \code{pattern} argument of
\code{\link[=tar_target]{tar_target()}} to get started. \code{pattern} accepts a function call
composed of target names and any of the following patterns:
\itemize{
\item \code{map()}: iterate over one or more targets in sequence.
\item \code{cross()}: iterate over combinations of slices of targets.
\item \code{head()}: restrict branching to the first few elements.
\item \code{tail()}: restrict branching to the last few elements.
\item \code{sample()}: restrict branching to a random subset of elements.
}
}
\examples{
# To use dynamic map for real in a pipeline,
# call map() in a target's pattern.
# The following code goes at the bottom of _targets.R.
list(
  tar_target(x, seq_len(2)),
  tar_target(y, head(letters, 2)),
  tar_target(dynamic, c(x, y), pattern = map(x, y)) # 2 branches
)
# Likewise for more complicated patterns.
list(
  tar_target(x, seq_len(2)),
  tar_target(y, head(letters, 2)),
  tar_target(z, head(LETTERS, 2)),
  tar_target(dynamic, c(x, y, z), pattern = cross(z, map(x, y))) #4 branches
)
# But you can emulate dynamic branching without running a pipeline
# in order to understand the patterns you are creating. Simply supply
# the pattern and the length of each dependency target.
# The returned data frame represents the branching structure of the pattern:
# One row per new branch, one column per dependency target, and
# one element per bud/branch in each dependency target.
tar_pattern(
  cross(x, map(y, z)),
  x = 2,
  y = 3,
  z = 3
)
tar_pattern(
  head(cross(x, map(y, z)), n = 2),
  x = 2,
  y = 3,
  z = 3
)
}
