% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_knitr.R
\name{walk_call_knitr}
\alias{walk_call_knitr}
\title{Code analysis for knitr reports.}
\usage{
walk_call_knitr(expr, counter)
}
\arguments{
\item{expr}{A language object or function to scan.}

\item{counter}{An internal counter object that keeps track of detected
target names so far.}
}
\value{
A character vector of target names found during static code analysis.
}
\description{
Walk an abstract syntax tree and capture knitr dependencies.
}
\details{
For internal use only. Not a user-side function.
Powers  automatic detection of \code{tar_load()}/\code{tar_read()}
dependencies in \code{\link[=tar_render]{tar_render()}}.
Packages \code{codetools} and \code{CodeDepends} have different (more sophisticated
and elaborate) implementations of the concepts documented at
\url{https://adv-r.hadley.nz/expressions.html#ast-funs}.
}
\examples{
# How tar_render() really works:
expr <- quote({
  if (a > 1) {
    tar_load(target_name)
  }
  process_stuff(target_name)
})
walk_ast(expr, walk_call_knitr)
}
\keyword{internal}
