% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cutValue.R
\name{cutValue}
\alias{cutValue}
\title{Title cutValue}
\usage{
cutValue(x, i.start, i.end, value.start, value.end)
}
\arguments{
\item{x}{to be cut}

\item{i.start}{index value of the starting point for the cut to be performed}

\item{i.end}{index value of the ending point for the cut to be performed}

\item{value.start}{desired value at point i.start}

\item{value.end}{desired value at point i.end}
}
\value{
x after cut
}
\description{
cut a region of a spectra and substitutes it with a sequence with initial value i.start and end valye i.end
}
\examples{
npoints=1000
x=seq(1,npoints)
y=(dnorm(x, mean=npoints/2, sd=npoints/10))
ycut=cutSelect(y,10,40)
plot(y)
lines(ycut,col="red")

}
