% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_nc.R
\name{add_nc}
\alias{add_nc}
\title{Save an item to a NetCDF or add one tag sensor or metadata variable to a NetCDF archive file.}
\usage{
add_nc(file, D, vname)
}
\arguments{
\item{file}{The name of the netCDF file to which to save. If the name does not include a .nc suffix, this will be added automatically.}

\item{D}{The sensor data or metadata list to be saved.}

\item{vname}{The name of the sensor data stream to be saved. Defaults to the entry "name" from the sensor or metadata list provided by the user (but an option to specify a name is provided to facilitate calling this function from \code{save_nc}).}
}
\value{
no return; adds a structure to an \code{animaltag} object
}
\description{
Add one tag sensor or metadata variable to a NetCDF archive file. If the archive file does not exist,
it is created. The file is assumed to be in the current working directory
unless a pathname is added to the beginning of fname.
}
\examples{
\dontshow{
.old_wd <- setwd(tempdir())
}
BW <- beaked_whale
add_nc("beaked_whale", njerk(BW$A), "Jerk")

\dontshow{
setwd(.old_wd)
}
}
\seealso{
\code{\link{save_nc}}, \code{\link{load_nc}}
}
