#' Ternary feldspar experiments and thermodynamic models
#'
#' A data set that has been manually transcribed from Table 5 of
#' Elkins and Grove's *Ternary feldspar experiments and thermodynamic models*.
#'
#' @section Abstract:
#' This paper reports the results of 20 experiments in which mixes of two or
#' three feldspars were reacted to produce coexisting plagioclase feldspar (PF)
#' and alkali feldspar (AF). Starting materials with similar bulk compositions
#' were prepared using different combinations of two and three minerals, and
#' experiments were designed to produce similar AF and PF minerals in the
#' experimental products from different starting binary and ternary
#' compositions. The coexisting AF and PF compositions produced as products
#' define compositional fields that are elongate parallel to the ternary solvus.
#' In 11 experiments reaction was sufficient to product fields of coexisting AF
#' and PF, or AF, PF, and melt with a bulk composition close to that of the
#' starting mixture. In six experiments significant reaction occurred in the
#' form of reaction rim overgrowths on seeds of the starting materials. Three
#' experiments produced AF, PF, and melt from a natural granite starting
#' material. A two-feldspar thermometer is presented in which temperature is
#' constrained by equilibria among all three components - Albite, Orthoclase,
#' and Anorthite - in coexisting ternary feldspars.
#'
#' @format A data frame of 40 rows and 7 columns:
#' \describe{
#'   \item{Experiment}{The ID of the experiment}
#'   \item{Feldspar}{Coexisting feldspars, *Alkali* or *Plagioclase*}
#'   \item{Or}{Proportion of orthoclase}
#'   \item{An}{Proportion of anorthite}
#'   \item{Ab}{Proportion of albite}
#'   \item{Temperature}{Temperature of the reaction (degrees centigrade)}
#'   \item{Pressure}{Pressure of the reaction (bars)}
#' }
#' @source Elkins LT, Grove TL. Ternary feldspar experiments and thermodynamic
#'   models. American Mineralogist. 1990;75(5-6):544-59.
"feldspar"
