% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bubbleplot.R
\name{bubbleplot}
\alias{bubbleplot}
\alias{bubbleplot.formula}
\title{Bubbleplots}
\usage{
bubbleplot(x, data = NULL, ...)

\method{bubbleplot}{formula}(x, data = NULL, maxsize = 3,
  bubblekey = TRUE, panel = panel.bubbleplot, groups = NULL,
  subset = TRUE,
  drop.unused.levels = lattice.getOption("drop.unused.levels"), ..., outer,
  allow.multiple)
}
\arguments{
\item{x}{A formula of the form \code{z ~ x * y}, where \code{x} and \code{y} have the usual
interpretation in trellis graphics (see \code{\link[lattice:xyplot]{lattice::xyplot()}}) and \code{z} is
mapped to the size of bubbles.}

\item{data}{A data.frame, list or environment wherein the formula and
groups arguments can be evaluated.}

\item{...}{Further arguments to pass to \code{\link[lattice:xyplot]{lattice::xyplot()}}.}

\item{maxsize}{Maximum size (in cex) for the bubbles.}

\item{bubblekey}{Set to \code{TRUE} to draw an informative legend about the
bubbles. Uses \code{\link[lattice:draw.key]{lattice::draw.key()}}. See the \strong{key} section of the
documentation in \code{\link[lattice:xyplot]{lattice::xyplot()}}. If both \code{auto.key} and \code{bubblekey}
are given and their \code{space} arguments (positions) conflict, bubblekey
will silently override the position of \code{auto.key}.}

\item{panel}{See \code{\link[lattice:xyplot]{lattice::xyplot()}}. Here, we are passing an additional
variable, \code{z}, which is then used in \code{\link[=panel.bubbleplot]{panel.bubbleplot()}}.}

\item{groups}{See \code{\link[lattice:xyplot]{lattice::xyplot()}}}

\item{subset}{See \code{\link[lattice:xyplot]{lattice::xyplot()}}}

\item{drop.unused.levels}{See \code{\link[lattice:xyplot]{lattice::xyplot()}}}

\item{outer}{Ignored.}

\item{allow.multiple}{Ignored.}
}
\value{
An object of class \code{"trellis"}. The
  \code{\link[lattice:update.trellis]{update}} method can be used to
  update components of the object and the
  \code{\link[lattice:print.trellis]{print}} method (usually called by
  default) will plot it on an appropriate plotting device.
}
\description{
Draws bubbleblots -- trivariate plots where the third dimension is mapped
to the size of the points drawn on the screen.
}
\examples{
bubbleplot(disp ~ hp * wt, groups = cyl, data = mtcars, auto.key = TRUE)
bubbleplot(disp ~ hp * mpg | factor(cyl), groups = gear, data = mtcars,
           auto.key = TRUE)
}
\author{
Johan Larsson
}
