/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula.writers;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import technology.tabula.Cell;
import technology.tabula.RectangularTextContainer;
import technology.tabula.Table;
import technology.tabula.TextChunk;
import technology.tabula.json.TableSerializer;
import technology.tabula.json.TextChunkSerializer;
import technology.tabula.writers.Writer;

public class JSONWriter
implements Writer {
    final Gson gson = new GsonBuilder().addSerializationExclusionStrategy(new TableSerializerExclusionStrategy()).registerTypeAdapter((Type)((Object)Table.class), new TableSerializer()).registerTypeAdapter((Type)((Object)RectangularTextContainer.class), new TextChunkSerializer()).registerTypeAdapter((Type)((Object)Cell.class), new TextChunkSerializer()).registerTypeAdapter((Type)((Object)TextChunk.class), new TextChunkSerializer()).create();

    @Override
    public void write(Appendable out, Table table) throws IOException {
        out.append(this.gson.toJson((Object)table, (Type)((Object)Table.class)));
    }

    @Override
    public void write(Appendable out, List<Table> tables) throws IOException {
        JsonArray array = new JsonArray();
        for (Table table : tables) {
            array.add(this.gson.toJsonTree(table, (Type)((Object)Table.class)));
        }
        out.append(this.gson.toJson(array));
    }

    class TableSerializerExclusionStrategy
    implements ExclusionStrategy {
        TableSerializerExclusionStrategy() {
        }

        @Override
        public boolean shouldSkipClass(Class<?> arg0) {
            return false;
        }

        @Override
        public boolean shouldSkipField(FieldAttributes fa) {
            return !fa.hasModifier(1);
        }
    }
}

