% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_metadata.R
\name{extract_metadata}
\alias{extract_metadata}
\title{extract_metadata}
\usage{
extract_metadata(file, password = NULL, copy = FALSE)
}
\arguments{
\item{file}{A character string specifying the path or URL to a PDF file.}

\item{password}{Optionally, a character string containing a user password to access a secured PDF.}

\item{copy}{Specifies whether the original local file(s) should be copied to
\code{tempdir()} before processing. \code{FALSE} by default. The argument is
ignored if \code{file} is URL.}
}
\value{
A list.
}
\description{
Extract metadata from a file
}
\details{
This function extracts metadata from a PDF
}
\examples{
# simple demo file
f <- system.file("examples", "mtcars.pdf", package = "tabulapdf")

extract_metadata(f)
}
\seealso{
\code{\link{extract_tables}}, \code{\link{extract_areas}}, \code{\link{extract_text}}, \code{\link{split_pdf}}
}
\author{
Thomas J. Leeper <thosjleeper@gmail.com>
}
