% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/diversity_alpha.R
\docType{methods}
\name{index_simpson}
\alias{index_simpson}
\alias{index_simpson-method}
\alias{index_simpson,numeric-method}
\title{Simpson Dominance Index}
\usage{
index_simpson(x, ...)

\S4method{index_simpson}{numeric}(x, evenness = FALSE, unbiased = FALSE, na.rm = FALSE, ...)
}
\arguments{
\item{x}{A \code{\link{numeric}} vector of count data (absolute frequencies).}

\item{...}{Currently not used.}

\item{evenness}{A \code{\link{numeric}} scalar: should evenness be computed?}

\item{unbiased}{A \code{\link{logical}} scalar: should the bias-corrected estimator be
used?}

\item{na.rm}{A \code{\link{numeric}} scalar: should missing values (including \code{NaN}) be
removed?}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Simpson Dominance Index
}
\details{
The Simpson index expresses the probability that two individuals randomly
picked from a finite sample belong to two different types. It can be
interpreted as the weighted mean of the proportional abundances. This
metric is a true probability value, it ranges from \eqn{0} (all taxa are
equally present) to \eqn{1} (one taxon dominates the community completely).

This is a \emph{dominance} index, so that an increase in the value of the index
accompanies a decrease in diversity.
}
\references{
Simpson, E. H. (1949). Measurement of Diversity. \emph{Nature}, 163(4148),
688-688. \doi{10.1038/163688a0}.
}
\seealso{
Other alpha diversity measures: 
\code{\link{index_ace}()},
\code{\link{index_baxter}()},
\code{\link{index_berger}()},
\code{\link{index_boone}()},
\code{\link{index_brillouin}()},
\code{\link{index_chao1}()},
\code{\link{index_chao2}()},
\code{\link{index_hurlbert}()},
\code{\link{index_ice}()},
\code{\link{index_margalef}()},
\code{\link{index_mcintosh}()},
\code{\link{index_menhinick}()},
\code{\link{index_shannon}()},
\code{\link{index_squares}()}
}
\author{
N. Frerebeau
}
\concept{alpha diversity measures}
