% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot-date.R, R/plot-time.R
\docType{methods}
\name{plot_date}
\alias{plot_date}
\alias{plot_date-method}
\alias{plot_time}
\alias{plot_time-method}
\alias{plot_date,AbundanceMatrix-method}
\alias{plot_date,DateModel-method}
\alias{plot_time,CountMatrix-method}
\title{Date and Time Plot}
\usage{
plot_date(object, ...)

plot_time(object, ...)

\S4method{plot_date}{AbundanceMatrix}(object, select = NULL,
  sort = "dsc")

\S4method{plot_date}{DateModel}(object, type = c("activity", "tempo"),
  event = FALSE, select = 1, n = 500)

\S4method{plot_time}{CountMatrix}(object, highlight = NULL,
  level = 0.95, roll = FALSE, window = 5, facet = TRUE, ...)
}
\arguments{
\item{object}{An object of class \linkS4class{DateModel} to be plotted.}

\item{...}{Further arguments to be passed to internal methods.}

\item{select}{A \code{\link{numeric}} or \code{\link{character}} vector
giving the selection of the assemblage that are drawn.}

\item{sort}{A \code{\link{character}} string indicating whether the dates
should be sorted. It can be one of "\code{asc}" or "\code{dsc}" (default).
Any unambiguous substring can be given. If \code{NULL} no sorting is
performed.}

\item{type}{A \code{\link{character}} string indicating the type of plot.
It must be one of "\code{activity}" (default) or "\code{tempo}".
Any unambiguous substring can be given.}

\item{event}{A \code{\link{logical}} scalar: should the distribution of the
event date be displayed? Only used if type is "\code{activity}".}

\item{n}{A length-one non-negative \code{\link{numeric}} vector giving the
desired length of the vector of quantiles for density computation.}

\item{highlight}{A \code{\link{character}} string indicating the type of
plot. It must be one of "\code{FIT}" or \code{NULL} (default).
Any unambiguous substring can be given.}

\item{level}{A length-one \code{\link{numeric}} vector giving the
confidence level.}

\item{roll}{A \code{\link{logical}} scalar: should each time series be
subsetted to look for episodes of selection?
Only used if \code{highlight} is "\code{FIT}" (see details).}

\item{window}{An odd \code{\link{integer}} giving the size of the rolling
window. Only used if \code{roll} is \code{TRUE}.}

\item{facet}{A \code{\link{logical}} scalar: should a matrix of panels
defined by type/taxon be drawn? Only used if \code{highlight} is
\code{NULL}.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
\code{plot_date} produces an activity or tempo plot.
}
\details{
\code{plot_time} produces an abundance \emph{vs.} time diagram.
}
\note{
Displaying FIT results on an abundance \emph{vs.} time diagram is
 adapted from Ben Marwick's original
 \href{https://github.com/benmarwick/signatselect/}{idea}.
}
\section{Event and Acccumulation Dates}{

 \code{plot_date} plots the probability estimate density curves of
 archaeological assemblage dates (\emph{event} and
 \emph{accumulation} dates; Bellanger and Husi 2012).
 The \emph{event date} is plotted as a line, while the \emph{accumulation
 date} is shown as a grey filled area.

 The accumulation date can be displayed as a tempo plot (Dye 2016) or an
 activity plot (Philippe and Vibet 2017):
 \describe{
  \item{Tempo plot}{A tempo plot estimates the cumulative occurrence of
  archaeological events, such as the slope of the plot directly reflects the
  pace of change.}
  \item{Activity plot}{An activity plot displays the first derivative of the
  tempo plot.}
 }
}

\section{Detection of Selective Processes}{

 Results of the frequency increment test can be displayed on an abundance
 \emph{vs.} time diagram aid in the detection and quantification of selective
 processes in the archaeological record. If \code{roll} is \code{TRUE},
 each time series is subsetted according to \code{window} to see if episodes
 of selection can be identified among decoration types that might not show
 overall selection. If so, shading highlights the data points where
 \code{\link{test_fit}} identifies selection.
}

\examples{
## Coerce the merzbach dataset to a count matrix
## Keep only decoration types that have a maximum frequency of at least 50
keep <- apply(X = merzbach, MARGIN = 2, FUN = function(x) max(x) >= 50)
merzbach_count <- as_count(merzbach[, keep])

## The data are grouped by phase
## We use the row names as time coordinates (roman numerals)
set_dates(merzbach_count) <- rownames(merzbach)
## Plot time vs abundance
plot_time(merzbach_count)
## Plot time vs abundance and highlight selection
plot_time(merzbach_count, highlight = "FIT", roll = TRUE)
}
\references{
Bellanger, L. & Husi, P. (2012). Statistical Tool for Dating and
 Interpreting Archaeological Contexts Using Pottery. \emph{Journal of
 Archaeological Science}, 39(4), 777-790.
 DOI: \href{https://doi.org/10.1016/j.jas.2011.06.031}{10.1016/j.jas.2011.06.031}.

 Dye, T. S. (2016). Long-Term Rhythms in the Development of Hawaiian
 Social Stratification. \emph{Journal of Archaeological Science}, 71, 1-9.
 DOI: \href{https://doi.org/10.1016/j.jas.2016.05.006}{10.1016/j.jas.2016.05.006}.

 Philippe, A. & Vibet, M.-A. (2017). Analysis of Archaeological Phases using
 the CRAN Package ArchaeoPhases. HAL,
 \href{https://hal.archives-ouvertes.fr/hal-01347895v3}{hal-01347895},
 v3.
}
\seealso{
\link{date_event}, \link{test}

Other plot: \code{\link{plot_bar}},
  \code{\link{plot_line}}, \code{\link{plot_matrix}},
  \code{\link{plot_spot}}
}
\author{
N. Frerebeau
}
\concept{plot}
