% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{plotSpot}
\alias{plotSpot}
\alias{plotSpot-method}
\alias{plotSpot,CountMatrix-method}
\alias{plotSpot,FrequencyMatrix-method}
\alias{plotSpot,SimilarityMatrix-method}
\alias{plotSpot,OccurrenceMatrix-method}
\title{Spot plot}
\usage{
plotSpot(object, ...)

\S4method{plotSpot}{CountMatrix}(object, threshold = NULL)

\S4method{plotSpot}{FrequencyMatrix}(object, threshold = NULL)

\S4method{plotSpot}{SimilarityMatrix}(object)

\S4method{plotSpot}{OccurrenceMatrix}(object)
}
\arguments{
\item{object}{An object to be plotted.}

\item{...}{Further arguments passed to other methods.}

\item{threshold}{A \code{\link{function}} that takes a numeric vector as
argument and returns a single numeric value (see details).
If \code{NULL}, no threshold is computed.}
}
\description{
Plots a spot matrix.
}
\details{
Note that rows are scaled to 0-1 (frequencies).
}
\note{
Adapted from Dan Gopstein's original
 \href{https://dgopstein.github.io/articles/spot-matrix/}{spot matrix}.
 Credit should be given to him.
}
\examples{
# Plot spot diagram...

## ...of count data...
count <- as(mississippi, "CountMatrix")
### ...without threshod
plotSpot(count)
### ...with the  column means as threshold
plotSpot(count, threshold = mean)
### ...with the column medians as threshold
plotSpot(count, threshold = median)

## ...of a similarity matrix
sim <- similarity(count, "brainerd")
plotSpot(sim)

## ...of a co-occurence matrix
occ <- as(mississippi, "OccurrenceMatrix")
plotSpot(occ)
}
\seealso{
Other plot: \code{\link{plotBar}}, \code{\link{plotDate}},
  \code{\link{plotMatrix}}, \code{\link{plotRank}}
}
\author{
N. Frerebeau
}
\concept{plot}
