% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{IncidenceMatrix-class}
\alias{IncidenceMatrix-class}
\alias{IncidenceMatrix}
\title{Incidence matrix}
\usage{
IncidenceMatrix(data = NA, nrow = 1, ncol = 1, byrow = FALSE,
  dimnames = NULL)
}
\arguments{
\item{data}{an optional data vector (including a list or
    \code{\link{expression}} vector).  Non-atomic classed \R objects are
    coerced by \code{\link{as.vector}} and all attributes discarded.}

\item{nrow}{the desired number of rows.}

\item{ncol}{the desired number of columns.}

\item{byrow}{logical. If \code{FALSE} (the default) the matrix is
    filled by columns, otherwise the matrix is filled by rows.}

\item{dimnames}{A \code{\link{dimnames}} attribute for the matrix:
    \code{NULL} or a \code{list} of length 2 giving the row and column
    names respectively.  An empty list is treated as \code{NULL}, and a
    list of length one as row names.  The list can be named, and the
    list names will be used as names for the dimensions.}
}
\description{
An S4 class to represent an incidence (presence/absence) matrix.
}
\details{
Numeric values are coerced to \code{\link{logical}} as by
 \code{\link[base]{as.logical}}.
}
\note{
This class extends the \code{base} \link[base]{matrix}.
}
\examples{
# Create an incidence (presence/absence) matrix
# Data will be coerced with as.logical()
A <- IncidenceMatrix(data = sample(0:1, 100, TRUE, c(1, 0.3)),
                      nrow = 10, ncol = 10)

# Coerce to a co-occurrence matrix
B <- as(A, "OccurrenceMatrix")

# Create a count data matrix
C <- CountMatrix(data = sample(0:10, 100, TRUE),
                 nrow = 10, ncol = 10, byrow = TRUE)

# Coerce to presence/absence
D <- as(C, "IncidenceMatrix")

# Coerce to a co-occurrence matrix
E <- as(C, "OccurrenceMatrix")
}
\seealso{
\link[base]{matrix}
}
\author{
N. Frerebeau
}
\concept{logical matrix}
