% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chords.R
\name{chord_is_major}
\alias{chord_is_major}
\alias{chord_is_minor}
\title{Check if chords are major or minor}
\usage{
chord_is_major(notes)

chord_is_minor(notes)
}
\arguments{
\item{notes}{character, a noteworthy string.}
}
\value{
logical vector
}
\description{
Check if chords are major or minor where possible.
}
\details{
These functions operate based only on ordered pitches.
They do not recognize what a human might interpret and name an inverted
chord with a root other than the lowest pitch.
This imposes limitations on the utility of these functions,
which scan the intervals for a minor or major third in a chord whose notes
are sorted by pitch.

In several cases including single notes or no major or minor third interval
present, \code{NA} is returned.
\code{TRUE} or \code{FALSE} is only returned if such an interval is present.
If more than one is present, it is based on the lowest in pitch.
It prioritizes major/minor and minor/major adjacent intervals (recognizing a
common triad). If these do not occur adjacent, the lowest third is selected.
This is still imperfect, but a useful method. Second and higher unknown
chord inversions are problematic.
}
\examples{
x <- "c cg, ce ce_ ceg ce_gb g,ce g,ce_ e_,g,c e_,g,ce_ e_,g,c"
chord_is_major(x)
identical(chord_is_major(x), !chord_is_minor(x))
}
