% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notes.R
\name{note-coerce}
\alias{note-coerce}
\alias{naturalize}
\alias{sharpen_flat}
\alias{flatten_sharp}
\alias{note_set_key}
\alias{as_tick_octaves}
\alias{as_integer_octaves}
\alias{as_space_time}
\alias{as_vector_time}
\alias{pretty_notes}
\title{Basic noteworthy strings formatting and coercion helpers}
\usage{
naturalize(notes, type = c("both", "flat", "sharp"))

sharpen_flat(notes)

flatten_sharp(notes)

note_set_key(notes, key = "c")

as_tick_octaves(notes)

as_integer_octaves(notes)

as_space_time(x)

as_vector_time(x)

pretty_notes(notes, ignore_octave = TRUE)
}
\arguments{
\item{notes}{character, a noteworthy string, space-delimited or vector of
individual entries.}

\item{type}{character, type of note to naturalize.}

\item{key}{character, key signature to coerce any accidentals to the
appropriate form for the key. May also specify \code{"sharp"} or
\code{"flat"}.}

\item{x}{for generic functions: notes, info or music string.}

\item{ignore_octave}{logical, strip any octave notation that may be present,
returning only the basic notes without explicit pitch.}
}
\value{
character
}
\description{
Helper functions for setting formatting attributes of
noteworthy strings including representation of timesteps, octaves and
accidentals.
}
\details{
For \code{sharpen_flat} and \code{flatten_sharp}, sharpening flats and
flattening sharps refer to inverting their respective notation,
not to raising or lowering a flatted or sharped note by one semitone.
For the latter, use \code{naturalize}, which removes flat and/or sharp
notation from a string.
\code{note_set_key} is used for coercing a noteworthy string to a specific
and consistent notation for accidentals based on a key signature.
This is a wrapper around \code{sharpen_flat} and \code{flatten_sharp}.
\code{as_tick_octaves}, \code{as_integer_octaves}, \code{as_space_time} and
\code{as_vector_time} similarly affect octave and timestep format.
For simultaneous control over the representation of timesteps, octave
numbering and accidentals, all three are available as arguments to
\code{\link{as_noteworthy}}.
}
\section{A note on generic functions}{

\code{as_space_time} and \code{as_vector_time} are generic since they
apply clearly to and are useful for not only noteworthy strings, but also
note info and music objects. If \code{x} is still a simple character string,
these functions attempt to guess which of the three it is. It is recommended
to set the class before using these functions.

There are many package functions that operate on noteworthy strings that
could in concept work on music objects, but the expectation is that sound
and time/info are disentangled.
The music class is convenient for data entry, e.g., for transcription
purposes, but it is not sensible to perform data analysis with quantities
like pitch and time tightly bound together. This would only lead to
repetitive deconstructions and reconstructions of music class objects. Most
functions that operate on noteworthy strings or note info strings strictly
apply to one or the other. Generic functions are reserved for only the most
fundamental and generally applicable metadata retrieval and format coercion.
}

\examples{
x <- "e_2 a_, b_, c#f#a# c#'f#'a#''"
note_set_key(x, "f")
note_set_key(x, "g")
as_tick_octaves(x)
as_integer_octaves(x)
y <- as_vector_time(x)
is_vector_time(y)
is_space_time(as_space_time(y))

naturalize(x)
naturalize(x, "sharp")
sharpen_flat(x)
flatten_sharp(x)
pretty_notes(x)
}
\seealso{
\code{\link{note-checks}}, \code{\link{note-metadata}},
\code{\link{note-summaries}}, \code{\link{valid-notes}}
}
