% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chords.R
\name{dyad}
\alias{dyad}
\title{Construct a dyad}
\usage{
dyad(notes, interval, reverse = FALSE, key = "c", collapse = FALSE)
}
\arguments{
\item{notes}{character, vector of single notes (not a single space-delimited string).}

\item{interval}{integer or character vector; semitones or interval ID, respectively. See details.}

\item{reverse}{logical, reverse the transposition direction. Useful when \code{interval} is character.}

\item{key}{character, key signature.}

\item{collapse}{logical, collapse result into a single string ready for phrase construction.}
}
\value{
character
}
\description{
Construct a dyad given one note, an interval, and a direction.
}
\details{
The \code{interval} may be specified by semitones of by common interval name or abbreviation. See examples.
For a complete list of valid interval names and abbreviations see \code{\link{mainIntervals}}.
\code{key} enforces the use of sharps or flats. This function is based on \code{transpose}.
\code{notes} and \code{interval} may be vectors, but must be equal length. Recycling occurs only if one argument is scalar.
}
\examples{
dyad("a", 4)
x <- c("minor third", "m3", "augmented second", "A2")
sapply(x, function(x) dyad("a", x))
sapply(x, function(x) dyad("c'", x, reverse = TRUE))

x <- c("M3", "m3", "m3", "M3", "M3", "m3", "m3")
dyad(letters[c(3:7, 1, 2)], x)

x <- c("P1", "m3", "M3", "P4", "P5", "P8", "M9")
dyad("c", x)
dyad("c", x, reverse = TRUE)
}
\seealso{
\code{\link{mainIntervals}}
}
