% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab.R
\name{lilypond}
\alias{lilypond}
\title{Save score to LilyPond file}
\usage{
lilypond(score, file, key = "c", time = "4/4", tempo = "2 = 60",
  header = NULL, string_names = NULL, paper = NULL, endbar = TRUE,
  midi = TRUE, path = NULL)
}
\arguments{
\item{score}{a score object.}

\item{file}{character, LilyPond output file ending in \code{.ly}. May include an absolute or relative path.}

\item{key}{character, key signature, e.g., \code{c}, \code{b_}, \code{f#m}, etc.}

\item{time}{character, defaults to \code{"4/4"}.}

\item{tempo}{character, defaults to \code{"2 = 60"}.}

\item{header}{a named list of arguments passed to the header of the LilyPond file. See details.}

\item{string_names}{label strings at beginning of tab staff. \code{NULL} (default) for non-standard tunings only, \code{TRUE} or \code{FALSE} for force on or off completely.}

\item{paper}{a named list of arguments for the LilyPond file page layout. See details.}

\item{endbar}{character, the end bar.}

\item{midi}{logical, add midi inclusion specification to LilyPond file.}

\item{path}{character, optional output directory prefixed to \code{file}, may be an absolute or relative path. If \code{NULL} (default), only \code{file} is used.}
}
\value{
nothing returned; a file is written.
}
\description{
Write a score to a LilyPond format (\code{.ly}) text file for later use by LilyPond or subsequent editing outside of R.
}
\details{
All \code{header} list elements are character strings. The options for \code{header} include:
\itemize{
  \item \code{title}
  \item \code{subtitle}
  \item \code{composer}
  \item \code{album}
  \item \code{arranger}
  \item \code{instrument}
  \item \code{meter}
  \item \code{opus}
  \item \code{piece}
  \item \code{poet}
  \item \code{copyright}
  \item \code{tagline}
}

All \code{paper} list elements are numeric except \code{page_numbers}, which is logical. The options for \code{paper} include:
\itemize{
  \item \code{textheight}
  \item \code{linewidth}
  \item \code{indent}
  \item \code{first_page_number}
  \item \code{page_numbers}
  \item \code{fontsize}
}
}
\examples{
x <- phrase("c ec'g' ec'g'", "4 4 2", "5 432 432")
x <- track(x)
x <- score(x)
outfile <- file.path(tempdir(), "out.ly")
lilypond(x, outfile)
}
\seealso{
\code{\link{tab}}, \code{\link{midily}},
}
