% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.castYearmonth.R
\name{types.castYearmonth}
\alias{types.castYearmonth}
\title{Cast a specific month in a specific year}
\usage{
types.castYearmonth(format, value)
}
\arguments{
\item{format}{no options (other than the default)}

\item{value}{list or string with yearmonth to cast}
}
\description{
Cast a specific month in a specific year as per \href{https://www.w3.org/TR/xmlschema-2/#gYearMonth}{XMLSchema gYearMonth}. 
Usual lexical representation is: YYYY-MM.
}
\examples{

types.castYearmonth(format = "default", value = list(2000, 10))

types.castYearmonth(format = "default", value = "2018-11")

}
\seealso{
\href{https://specs.frictionlessdata.io//table-schema/#yearmonth}{Types and formats specifications}
}
