% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.checkMaxLength.R
\name{constraints.checkMaxLength}
\alias{constraints.checkMaxLength}
\title{Check if maximum character length constraint is met}
\usage{
constraints.checkMaxLength(constraint, value)
}
\arguments{
\item{constraint}{numeric constraint, maximum character length}

\item{value}{character to meet the constraint}
}
\value{
TRUE if character length is equal to or less than the constraint
}
\description{
Specify the maximum length of a character
}
\examples{

constraints.checkMaxLength(constraint = list(2), value = "hi")

constraints.checkMaxLength(constraint = 2, value = "hello")
}
\seealso{
\href{https://specs.frictionlessdata.io//table-schema/#constraints}{Constraints specifications}
}
