% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_thead_css.R
\name{add_css_thead}
\alias{add_css_thead}
\title{Add css to the thead tag}
\usage{
add_css_thead(tableHTML, css)
}
\arguments{
\item{tableHTML}{A tableHTML object created by the tableHTML function.}

\item{css}{A list of two elements with the corresponding css. The first element of the list
should be an atomic vector with the style definitions (e.g. background-color). The second
element will be an atomic vector with the same length as the first element, which will 
contain the style definitions' values (e.g. red). Check the examples for more information.}
}
\value{
A tableHTML object.
}
\description{
\code{add_css_thead} will add css to the thead tag i.e. to headers and second_headers.
}
\details{
\code{add_css_thead} will add css to the thead tag i.e. to headers and second_headers.
}
\examples{
tableHTML(mtcars) \%>\% 
  add_css_thead(css = list('background-color', 'lightgray')) 
  
tableHTML(mtcars) \%>\% 
  add_css_thead(css = list('background-color', 'lightgray')) \%>\%
  add_css_thead(css = list('background-color', 'lightblue')) 
  
tableHTML(mtcars) \%>\% 
  add_css_thead(css = list('background-color', 'lightgray')) \%>\%
  add_css_thead(css = list('text-align', 'center'))
  

}
