% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_column_css.R
\name{add_css_column}
\alias{add_css_column}
\title{Add css to tableHTML's columns}
\usage{
add_css_column(tableHTML, css, column_names)
}
\arguments{
\item{tableHTML}{A tableHTML object created by the tableHTML function.}

\item{css}{A list of two elements with the corresponding css. The first element of the list
should be an atomic vector with the style definitions (e.g. background-color). The second
element will be an atomic vector with the same length as the first element, which will 
contain the style definitions' values (e.g. red). Check the examples for more information.}

\item{column_names}{A character atomic vector with the names of the columns where the style
definitions will be applied on. At least one column name must be provided. If the rownames
are included the column name is "rownames". If row_groups are are included the column name
is "row_groups".}
}
\value{
A tableHTML object.
}
\description{
\code{add_css_column} will add css to a tableHTML's columns
}
\details{
\code{add_css_column} will add css to a tableHTML's columns.
}
\examples{
tableHTML(mtcars) \%>\% 
  add_css_column(css = list(c('background-color', 'border'), c('lightgray', '3px solid green')),
                 column_names = 'mpg') 

tableHTML(mtcars) \%>\% 
  add_css_column(css = list(c('background-color', 'border'), c('lightgray', '3px solid green')), 
                 column_names = c('mpg', 'disp', 'rownames'))
                 
tableHTML(mtcars, 
          rownames = FALSE, 
          widths = c(120, rep(50, 11)),
          row_groups = list(c(10, 10, 12), c('Group 1', 'Group 2', 'Group 3'))) \%>\%
  add_css_column(css = list('background-color', 'lightgray'), column_names = 'row_groups') \%>\%
  add_css_header(css = list('background-color', 'lightgray'), headers = 1)
                 
                 
}

