% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table1.R
\name{indexed}
\alias{indexed}
\title{A simple class for indexed data.}
\usage{
indexed(x, i, ...)
}
\arguments{
\item{x}{An atomic vector or \code{\link{data.frame}}.}

\item{i}{An optional vector of indices (dafaults to \code{1:n}, where
\code{n} is the number of elements in \code{x}).}

\item{...}{Other arguments passed to methods.}
}
\value{
An object identical to \code{x} but with the additional class
\code{indexed} and a \code{indices} attribute.
}
\description{
A simple class for indexed data.
}
\examples{
x <- c(3.7, 3.3, 3.5, 2.8)
y <- c(1, 2, 1, 2)

z <- indexed(x=x)
indices(z)
indices(z[2:3])  # Indices are preserved

d <- indexed(
  data.frame(
    x=x,
    y=y
  )
)

indices(d)
indices(d[[1]])
indices(d$x)
indices(subset(d, y==1))
lapply(split(d, d$y), indices)
}
