% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatp.R
\name{formatp}
\alias{formatp}
\title{Format P-values for Functions in the \pkg{tab} Package}
\usage{
formatp(p, decimals = c(2, 3), cuts = 0.01, lowerbound = 0.001,
  leading0 = TRUE, avoid1 = FALSE)
}
\arguments{
\item{p}{Numeric vector of p-values.}

\item{decimals}{Number of decimal places for p-values. If a vector is
provided rather than a single value, number of decimal places will depend on
what range the p-value lies in. See \code{cuts} input.}

\item{cuts}{Cut-point(s) to control number of decimal places used for
p-values. For example, by default \code{cuts = 0.1} and
\code{decimals = c(2, 3)}. This means that p-values in the range [0.1, 1]
will be printed to two decimal places, while p-values in the range [0, 0.1)
will be printed to three decimal places.}

\item{lowerbound}{Controls cut-point at which p-values are no longer printed
as their value, but rather <lowerbound. For example, by default
\code{lowerbound = 0.001}. Under this setting, p-values less than 0.001 are
printed as \code{<0.001}.}

\item{leading0}{If \code{TRUE}, p-values are printed with 0 before decimal
place; if \code{FALSE}, the leading 0 is omitted.}

\item{avoid1}{If \code{TRUE}, p-values rounded to 1 are not printed as 1, but
as \code{>0.99} (or similarly depending on \code{decimals} and \code{cuts}).}
}
\value{
Character vector.
}
\description{
Formats p-values for tables generated by the functions in the \pkg{tab}
package. Handles rounding and presentation of p-values.
}
\examples{
# Generate vector of numeric p-values
set.seed(123)
p <- c(runif(n = 5, min = 0, max = 1), 1, 0, 4e-7, 0.009)

# Round to nearest 2 decimals for p in (0.01, 1] and 3 decimals for p < 0.01
pvals <- formatp(p = p)

# Use 2 decimal places, a lower bound of 0.01, and omit the leading 0
pvals <- formatp(p = p, decimals = 2, lowerbound = 0.01, leading0 = FALSE)

}
