% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.watching.R
\name{trakt.movie.watching}
\alias{trakt.movie.watching}
\title{Get users watching a movie}
\usage{
trakt.movie.watching(target, extended = "min")
}
\arguments{
\item{target}{The \code{id} of the movie requested. Either the \code{slug}
(e.g. \code{"tron-legacy-2010"}), \code{trakt id} or \code{IMDb id}}

\item{extended}{Whether extended info should be provided.
Defaults to \code{"min"}, can either be \code{"min"} or \code{"full"}}
}
\value{
A \code{data.frame} containing user information
}
\description{
\code{trakt.movie.watching} returns trakt.tv users who are watching this movie.
}
\note{
See \href{http://docs.trakt.apiary.io/reference/movies/watching/get-users-watching-right-now}{the
 trakt API docs for further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
trakt.movie.watching("tron-legacy-2010")
}
}
\seealso{
Other movie data: \code{\link{trakt.movie.people}};
  \code{\link{trakt.movie.ratings}};
  \code{\link{trakt.movie.releases}};
  \code{\link{trakt.movie.summary}};
  \code{\link{trakt.movies.popular}};
  \code{\link{trakt.movies.related}};
  \code{\link{trakt.movies.trending}};
  \code{\link{trakt.stats}}
}

