% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kostka.R
\name{KostkaNumber}
\alias{KostkaNumber}
\title{Kostka numbers}
\usage{
KostkaNumber(lambda, mu)
}
\arguments{
\item{lambda}{an integer partition}

\item{mu}{an integer vector whose sum equals the weight (i.e. the sum) of 
\code{lambda}}
}
\value{
The Kostka number corresponding to \code{lambda} and \code{mu}.
}
\description{
Computes a Kostka number.
}
\details{
The Kostka number \eqn{K(\lambda,\mu)} is the number of semistandard 
  Young tableaux with shape \eqn{\lambda} and weight \eqn{\mu}. It does 
  not depend on the order of the elements of \eqn{\mu} (so one can always 
  take an integer partition for \eqn{\mu}). The \emph{weight} is the 
  vector whose \eqn{i}-th element is the number of occurences of \eqn{i} 
  in the tableau.
}
\examples{
KostkaNumber(c(3,2), c(1,1,1,2))
KostkaNumber(c(3,2), c(1,1,2,1))
KostkaNumber(c(3,2), c(1,2,1,1))
KostkaNumber(c(3,2), c(2,1,1,1))
}
