% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen_Friedman.R
\name{data.gen.fm1}
\alias{data.gen.fm1}
\title{Friedman with independent uniform variates}
\usage{
data.gen.fm1(nobs, ndim = 9, noise = 1)
}
\arguments{
\item{nobs}{The data length to be generated.}

\item{ndim}{The number of potential predictors (default is 9).}

\item{noise}{The noise level in the time series.}
}
\value{
A list of 3 elements: a vector of response (x), a matrix of potential predictors (dp) with each column containing one potential predictor, and a vector of true predictor numbers.
}
\description{
Friedman with independent uniform variates
}
\examples{
###synthetic example - Friedman
#Friedman with independent uniform variates
data.fm1 <- data.gen.fm1(nobs=1000, ndim = 9, noise = 0)

#Friedman with correlated uniform variates
data.fm2 <- data.gen.fm2(nobs=1000, ndim = 9, r = 0.6, noise = 0)

plot.ts(cbind(data.fm1$x,data.fm2$x), col=c("red","blue"), main=NA, xlab=NA,
        ylab=c("Friedman with \n independent uniform variates",
        "Friedman with \n correlated uniform variates"))
}
