% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_anneal_wrappers.R
\name{all_geogs_add_constraint}
\alias{all_geogs_add_constraint}
\title{Add new constraint to a set of geographies}
\usage{
all_geogs_add_constraint(attr_name = "variable", attr_total_list, macro_micro,
  constraint_list_list = NULL)
}
\arguments{
\item{attr_name}{The name of the attribute, or variable, that you wish to constrain.}

\item{attr_total_list}{A list of named integer vectors containing counts per level of the new 
constraining attribute for each geography.}

\item{macro_micro}{The geographical dataset of macro and micro data. Should be of class 
\code{"macro_micro"}.}

\item{constraint_list_list}{A \code{list} of lists containing prior constraints on the same dataset 
for which you wish to add to. Defaults to \code{NULL} (ie. the default is that this is the first 
constraint.)}
}
\value{
A list of constraint lists.
}
\description{
Add a new constraint to the mapping between a a set of macro datasets and a matching 
set of micro dataset (supplied as class 'macro_micro'). May be called repeatedly to create a 
set of constraints across the sub-geographies.
}
\examples{
\dontrun{
# assumes that micro_synthetic already exists in your environment

# 1. build constraints for gender and age
g <- all_geog_constraint_gender(micro_synthetic, method= "macro.table")

a <- all_geog_constraint_age(micro_synthetic, method= "macro.table")

# 2. bind constraints to geographies and macro-data
cll <- all_geogs_add_constraint(attr_name= "age", attr_total_list= a, 
          macro_micro= micro_synthetic)
cll <- all_geogs_add_constraint(attr_name= "gender", attr_total_list= g, 
          macro_micro= micro_synthetic, constraint_list_list= cll)

}
}
\seealso{
\code{\link{add_constraint}}
}

