% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processes.R
\name{centered.process}
\alias{centered.process}
\title{Create a Centered Random Process}
\usage{
centered.process(
  name = c("WIENER", "WHITE.NOISE", "KL", "KARHUNEN.LOEVE", "GAUSSIAN"),
  domain = c(0, 1),
  ...
)
}
\arguments{
\item{name}{name of the process.}

\item{domain}{domain where the process is defined.}

\item{...}{other parameters required to define the process:
\describe{
  \item{dispersion}{required by Wiener process}
  \item{sig}{required by white noise process}
  \item{eigen.values}{required by process defined via K-L representation}
  \item{eigen.functions}{required by process defined via K-L representation}
  \item{distribution}{the distribution of PC scores, required by process defined via K-L representation}
}}
}
\value{
a function hanlde in the form of \code{X(tObs,n)} which generates \code{n} independent trajectories observed at \code{tObs}
}
\description{
Create a Centered Random Process
}
\examples{
X <- centered.process(name='wiener',dispersion=1)
X <- centered.process(name='white.noise',sig=1)
X(regular.grid(50),25)
}
