% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambdify.R
\name{lambdify}
\alias{lambdify}
\alias{as.function.BasicOrVecBasic}
\title{Convert A Basic/VecBasic Object to R Function}
\usage{
lambdify(x, args, backend = c("auto", "lambda", "llvm"), perform_cse = TRUE)

\method{as.function}{BasicOrVecBasic}(x, args, backend = "auto", perform_cse = TRUE, ...)
}
\arguments{
\item{x}{A Basic object or a VecBasic object.}

\item{args}{A VecBasic object specifying the arguments of the resulted function.
It will be passed to \code{\link{DoubleVisitor}} and can be missing.}

\item{backend}{One of "auto", "lambda" and "llvm". If "auto", 
\code{getOption("lambdify.backend")} will be used to determine the value. If that
option is not set, it will be determined based on \code{symengine_have_component("llvm")}.}

\item{perform_cse}{Passed to \code{\link{DoubleVisitor}}.}

\item{...}{Not used}
}
\value{
A \code{DoubleVisitor} S4 object.
}
\description{
These functions currently use \code{\link{DoubleVisitor}} to
convert a Basic/VecBasic object to a \code{DoubleVisitor} which
essentially is a S4 class extending R function.
}
\seealso{
\code{\link{DoubleVisitor}}
}
