% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/injector.R
\name{injector}
\alias{injector}
\title{Inject and eavesdrop a continuous variable.}
\arguments{
\item{eavesdrop}{The variable to track.}

\item{minimum}{The minimum value of \code{eavesdrop}. It defines the plot boundary}

\item{maximum}{The maximum value of \code{eavesdrop}. It defines the plot boundary}

\item{inject}{String of the variable name to be modified/injected by widgets.
For example, if \code{eavesdrop = i} then \code{inject = "i"}.}

\item{label}{A small caption/label for the widget.}

\item{size}{A number used to designate the size (magnification) of the
widget. The default is set to \code{1} which is 80 by 80 pixels. For
example, setting to \code{3} will results in a widget 3-times the default
size (240 by 240 pixels) and will occupy a grid area of 3 by 3.}

\item{placeOnGrid}{A row by column coordinate (e.g., \code{c(row-number, column-number)})
of a grid that designates the position to draw the widget on the
\code{switchboard}. Use \code{showGrid()} to help organize widget placement
on dashboard. The default places the first widget in pipe chain to
the \code{c(1, 1)} position, and all following on the same row stacked to
the right.}

\item{updates}{The number of times the widget is to be updated (e.g., when
it be modified/changed). The default updates the widget 100 times. Increase
number for smoother progress bar animation.}

\item{delay}{Pause each update of the switchboard. Default has no delay,
values are in seconds (e.g., \code{delay = 0.01} results in 0.01 second
delay with each iteration).}

\item{plotMean}{Display a small switchboard-estimated mean and standard deviation
whisker plot on a widget.}

\item{switch}{Display an on/off switch on a widget that controls widget updates.
When \code{TRUE} it will add the switch in the off-state on the switchboard.
The user must activate the switch to start the widget. The simulation proceeds
even if the switch in in the off-state.}
}
\value{
Nothing.
}
\description{
The \code{injector} widget displays a horizontal moving window of data with
a slider that injects/modifies characteristics of the data. (see
\code{injector_X} for a vertical version). The X-axis is time-lagged
and the widget keeps track of each point until it reaches the end of the
plot. This widget is univariate and only eavesdrops one variable; for a
bivariate version use \code{injector_2D}. The number of data points in the
window can be throttled with \code{delay}.
}
\section{Usage}{

   \preformatted{injector(eavesdrop, minimum = 1, maximum = 100, inject = "",
   label = "", size = 1, placeOnGrid = c(1, 1), updates = 100, delay = 0,
   plotMean = FALSE, switch = FALSE)}
}

\examples{
\dontrun{
     
     populationMean = 0
     for (i in 1:4000) {
       randomNormal <- rnorm(1, populationMean, 1)
       switchboard(delay = 0.01) \%>\%
         injector(randomNormal, inject = "populationMean", minimum = -5, maximum = 5)
     }
     switchboard_close()

}

}
\seealso{
Other eavesdroppers: 
\code{\link{benchmark}()},
\code{\link{counter_tally}()},
\code{\link{counter}()},
\code{\link{eavesdropper_2D}()},
\code{\link{eavesdropper_X}()},
\code{\link{eavesdropper}()},
\code{\link{injector_2D}()},
\code{\link{injector_X}()},
\code{\link{number_pair}()},
\code{\link{number_quartet}()},
\code{\link{number_trio}()},
\code{\link{number}()},
\code{\link{progress_benchmark}()}

Other injectors: 
\code{\link{control_slider_Y_pair}()},
\code{\link{control_slider_Y}()},
\code{\link{control_slider_pair}()},
\code{\link{control_slider}()},
\code{\link{control_switch_pair}()},
\code{\link{control_switch_trio}()},
\code{\link{control_switch}()},
\code{\link{injector_2D}()},
\code{\link{injector_X}()}

Other moving windows: 
\code{\link{eavesdropper_2D}()},
\code{\link{eavesdropper_X}()},
\code{\link{eavesdropper}()},
\code{\link{injector_2D}()},
\code{\link{injector_X}()}
}
\concept{eavesdroppers}
\concept{injectors}
\concept{moving windows}
