% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airdas_class.R
\name{airdas_dfr-class}
\alias{airdas_dfr-class}
\alias{airdas_dfr}
\title{\code{airdas_dfr} class}
\description{
The \code{airdas_dfr} class is a subclass of \code{\link[base]{data.frame}},
  created to provide a concise and robust way to ensure that the input 
  to \code{\link{airdas_process}}adheres to certain requirements.
  Specifically, objects of class \code{airdas_dfr} are data frames with specific column names and classes,
  as detailed in the 'Properties of \code{airdas_dfr}' section. 
  Objects of class \code{airdas_dfr} are created by
  \code{\link{airdas_read}} or \code{\link{as_airdas_dfr}}, 
  and are intended to be passed directly to \code{\link{airdas_process}}.

  Subsetting or otherwise altering an object of class \code{airdas_dfr} will cause 
  the object to drop its \code{airdas_dfr} class attribute, although note that combining
  two \code{airdas_dfr} objects using \code{\link[base:cbind]{rbind}} 
  will return an object with a \code{airdas_dfr} class attribute.
  \code{\link{airdas_process}} will then try to coerce the object to a
  \code{airdas_dfr} object. It is \bold{strongly} recommended to pass an object of class \code{airdas_dfr} to
  \code{\link{airdas_process}} before subsetting, e.g. for events from a certain date range.
}
\section{Properties of \code{airdas_dfr} objects}{


  Objects of class \code{airdas_dfr} have a class attribute of \code{c("airdas_dfr", "data.frame")}.
  They must have a column \code{file_type} where all values are one of: 
  "turtle", "caretta", "survey", or "phocoena" 
  (case sensitive; see \code{\link{airdas_read}} for more details). 
  \code{airdas_dfr} objects also must not have any \code{NA} event codes.
  
  In addition, they must have the following column names and classes:
  \tabular{ll}{
    \emph{Column name} \tab \emph{Column class}\cr
    Event     \tab "character"\cr
    EffortDot \tab "logical"\cr
    DateTime  \tab c("POSIXct", "POSIXt")\cr
    Lat       \tab "numeric"\cr
    Lon       \tab "numeric"\cr
    Data1 \tab "character"\cr
    Data2 \tab "character"\cr
    Data3 \tab "character"\cr
    Data4 \tab "character"\cr
    Data5 \tab "character"\cr
    Data6 \tab "character"\cr
    Data7 \tab "character"\cr
    EventNum  \tab "character"\cr
    file_das  \tab "character"\cr
    line_num  \tab "integer"\cr
    file_type \tab "character"\cr
  }
}

\seealso{
\code{\link{as_airdas_dfr}}
}
