% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airdas_chop_equallength.R
\name{airdas_chop_equallength}
\alias{airdas_chop_equallength}
\alias{airdas_chop_equallength.data.frame}
\alias{airdas_chop_equallength.airdas_df}
\title{Chop AirDAS data - equal length}
\usage{
airdas_chop_equallength(x, ...)

\method{airdas_chop_equallength}{data.frame}(x, ...)

\method{airdas_chop_equallength}{airdas_df}(
  x,
  conditions,
  seg.km,
  randpicks.load = NULL,
  distance.method = NULL,
  num.cores = NULL,
  ...
)
}
\arguments{
\item{x}{\code{airdas_df} object, 
or a data frame that can be coerced to a \code{airdas_df} object. 
This data must be filtered for 'OnEffort' events; 
see the Details section below}

\item{...}{ignored}

\item{conditions}{see \code{\link{airdas_effort}}}

\item{seg.km}{numeric; target segment length in kilometers}

\item{randpicks.load}{character, data frame, or \code{NULL}. 
If character, must be filename of past randpicks output to load and use 
(passed to \code{file} argument of \code{\link[utils:read.table]{read.csv}}).
If data frame, randpicks values will be extracted from the data frame.
If \code{NULL}, new randpicks values will be generated by the function}

\item{distance.method}{character; see \code{\link{airdas_effort}}.
Default is \code{NULL} since these distances should have already been
calculated in \code{\link{airdas_effort}}}

\item{num.cores}{See \code{\link{airdas_effort}}}
}
\value{
List of three data frames:
\itemize{
  \item \code{x}, with columns added for the corresponding unique segment code and number
  \item segdata: data frame with one row for each segment, and columns with
    relevant data (see \code{\link{airdas_effort}} for specifics)
  \item randpicks: data frame with record of length allocations 
    (see Details section above)
}
}
\description{
Chop AirDAS data into equal-length effort segments, averaging conditions by segment
}
\details{
WARNING - do not call this function directly!
  It is exported for documentation purposes, but is intended for internal package use only.

  This function is intended to only be called by \code{\link{airdas_effort}} 
  when the "equallength" method is specified. 
  Thus, \code{x} must be filtered for events (rows) where either
  the 'OnEffort' column is \code{TRUE} or the 'Event' column is either "E" or "O"; 
  see \code{\link{airdas_effort}} for more details. 
  This function chops each continuous effort section (henceforth 'effort sections') 
  in \code{x} into modeling segments (henceforth 'segments') of equal length. 
  Each effort section runs from a "T"/"R" event to its corresponding "E"/"O" event. 
  After chopping, \code{\link{airdas_segdata}} is called to get relevant  
  segdata information for each segment.

  When chopping the effort sections in segments of length \code{seg.km}, 
  there are several possible scenarios:
  \itemize{
    \item The extra length remaining after chopping is greater than or equal to 
      half of the target segment length (i.e. \code{>= 0.5*seg.km}): 
      the extra length is assigned to a random portion of the effort section as its own segment 
      (\href{https://github.com/smwoodman/swfscAirDAS/blob/master/inst/AirDAS_chop_equallength_figures.pdf}{see Fig. 1a})
    \item The extra length remaining after chopping is less than half of the 
      target segment length (i.e. \code{< 0.5*seg.km}): 
      the extra length is added to one of the (randomly selected) equal-length segments 
      (\href{https://github.com/smwoodman/swfscAirDAS/blob/master/inst/AirDAS_chop_equallength_figures.pdf}{see Fig. 1b})
    \item The length of the effort section is less than or equal to 
      the target segment length: the entire segment becomes a segment 
      (\href{https://github.com/smwoodman/swfscAirDAS/blob/master/inst/AirDAS_chop_equallength_figures.pdf}{see Fig. 1c})
    \item The length of the effort section is zero: a segment of length zero. 
      If there are more than two events (the "T"/R" and "E"/"O" events),
      the function throws a warning
  }
  
  Therefore, the length of each segment is constrained to be between 
  one half and one and one half of \code{seg.km} (i.e. \code{0.5*seg.km <=} 
  segment length \code{>=1.5*seg.km}), 
  and the central tendency is approximately equal to the target segment length. 
  The only exception is when a continuous effort section is less than 
  one half of the target segment length (i.e. \code{< 0.5*seg.km}; 
  \href{https://github.com/smwoodman/swfscAirDAS/blob/master/inst/AirDAS_chop_equallength_figures.pdf}{see Fig. 1c}).
  
  Note the PDF with Figs. 1a - 1c is included in the package, and can be found at:
  \code{system.file("AirDAS_chop_equallength_figures.pdf", package = "swfscAirDAS")}   
  
  'Randpicks' is a record of the random assignments that were made when 
  chopping the effort sections into segments, and can be saved to allow 
  users to recreate the same random allocation of extra km when chopping. 
  The randpicks returned by this function is a data frame with two columns: 
  the number of the effort section and the randpick value. 
  Users should save the randpicks output to a CSV file, 
  which then can be specified using the \code{randpicks.load} argument
  to recreate the same effort segments from \code{x} 
  (i.e., using the same AirDAS data) in the future.
  Note that when saving with \code{\link[utils:read.table]{write.csv}}, users must 
  specify \code{row.names = FALSE} so that the CSV file only has two columns.
  For an example randpicks file, see 
  \code{system.file("airdas_sample_randpicks.csv", package = "swfscAirDAS")}

  If the column \code{dist_from_prev} does not exist, the distance between
  subsequent events is calculated as described in \code{\link{airdas_effort}}
}
