% Generated by roxygen2 (4.0.2): do not edit by hand
\name{pin_format}
\alias{pin_format}
\title{Parse personal identity numbers to ABS format}
\usage{
pin_format(pin)
}
\arguments{
\item{pin}{Vector with swedish personal identity numbers in character or numeric format. See details.}
}
\value{
Character vector with swedish personal identity numbers with standard ABS format \code{"YYYYMMDDNNNC"}.
}
\description{
Converts personal identity numbers of different formats to standard (ABS) pin format \code{YYYYMMDDNNNC}
where \code{YYYYMMDD} is the date of birth, \code{NNN} is the birth number and \code{C} is the
control number.
}
\details{
The function converts different formats of swedish personal identity numbers to
the standard ABS format. The formats that can be converted are:
\itemize{
  \item numeric: \code{YYYYMMDDNNNC}
  \item numeric: \code{YYMMDDNNNC} (assuming < 100 years of age)
  \item character: \code{"YYYYMMDDNNNC"}
  \item character: \code{"YYMMDD-NNNC"}
  \item character: \code{"YYYYMMDD-NNNC"}
  \item character: \code{"YYMMDDNNNC"} (assuming < 100 years of age)
}
}
\examples{
# Examples taken from SKV 704 (see references)
ex_pin1 <- c("196408233234", "640823-3234", "19640823-3234")
pin_format(ex_pin1)
ex_pin2 <- c("6408233234")
pin_format(ex_pin2)
ex_pin3 <- c(6408233234, 196408233234)
pin_format(ex_pin3)
}
\references{
\href{https://www.skatteverket.se/download/18.8dcbbe4142d38302d74be9/1387372677724/717B06.pdf}{Population registration in Sweden}
\href{https://www.skatteverket.se/download/18.1e6d5f87115319ffba380001857/1285595720207/70408.pdf}{SKV 704}
\href{http://www.riksdagen.se/sv/Dokument-Lagar/Utredningar/Statens-offentliga-utredningar/Personnummer-och-samordningsnu_GWB360/}{SOU 2008:60 : Personnummer och samordningsnummer}
}

