% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics_calc_group.R
\name{group_metrics}
\alias{group_metrics}
\title{Group Metrics of Collective Motion}
\usage{
group_metrics(data, geo, step2time = 1, parallelize = FALSE)
}
\arguments{
\item{data}{A dataframe of (ordered) time series of headings,
positions, and speeds per individual. The dataframe may contain
several individuals. Should include the columns:
\code{id}, \code{t}, \code{speed}, \code{x}, \code{y}, \code{head}, \code{set}.}

\item{geo}{Logical, whether positions are geographic coordinates,
default = FALSE.}

\item{step2time}{Numeric, the sampling frequency of the data
(the relation between a row in the data and real time in seconds).}

\item{parallelize}{Logical, whether to parallelize over time.
Suggested only for very large datasets.}
}
\value{
A dataframe with the group average timeseries, with columns:
 \code{set}, \code{t}, \code{pol}, \code{speed}, \code{shape}, \code{N} (number of individuals),
 \code{missing_ind} (whether some individuals are missing).
}
\description{
This function calculates the average speed, polarization
and shape of a group through time.
}
\examples{
data <- data.frame(
 set = rep("1", 50),
 t = as.POSIXct(rep(1:25, 2), origin = Sys.time()),
 id = c(rep(1, 25), rep(2, 25)),
 x = rnorm(50),
 y = rnorm(50),
 head = runif(50, 0, 2 * pi),
 speed = rnorm(50)
 )

gm <- group_metrics(data,
 geo = FALSE,
 step2time = 1)

}
\seealso{
\code{\link{group_shape}, \link{add_velocities}}
}
\author{
Marina Papadopoulou \email{m.papadopoulou.rug@gmail.com}
}
