#' swaRmverse: Swarm Space Creation
#'
#' The \code{swaRmverse} package provides a pipeline for the comparative
#'  analysis of collective movement data (e.g. fish schools, bird flocks, baboon
#'  troops) by processing 2-dimensional positional data (x,y,t) from GPS
#'  trackers or computer vision tracking systems, discretizing events of
#' collective motion, calculating a set of established metrics that characterize
#' each event, and placing the events in a multi-dimensional 'swarm space'
#' constructed from these metrics.
#'
#' @author Marina Papadopoulou <m.papadopoulou.rug@@gmail.com>
#' @author Simon Garnier <garnier@@njit.edu>
#'
#' Maintainer: Marina Papadopoulou <m.papadopoulou.rug@@gmail.com>
#'
#' @details
#' \tabular{ll}{
#'  Package: \tab swaRmverse\cr
#'  Type: \tab Package\cr
#'  Version: \tab 0.1.0\cr
#'  Date: \tab 2024-02-29\cr
#'  License: \tab GPL-3\cr
#' }
#'
#' @references
#'  Papadopoulou Marina, Fürtbauer Ines, O'Bryan Lisa R., Garnier Simon,
#'  Georgopoulou Dimitra G., Bracken Anna M., Christensen Charlotte and King
#'  Andrew J. 2023. Dynamics of collective motion across time and species. Phil.
#'  Trans. R. Soc. B 378: 20220068. http://doi.org/10.1098/rstb.2022.0068
#'
#' @name swaRmverse
"_PACKAGE"
