% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svrep-package-options.R
\name{svrep-package-options}
\alias{svrep-package-options}
\title{Package-level Options for svrep}
\description{
This help page describes the overall
options that can be set for your R session,
using the function \code{options()}.
}
\section{Options for using the 'torch' package to speed up certain operations}{

The 'torch' package provides access to fast linear algebra routines
and is a particularly convenient approach to working with GPUs or
conducting multithreaded linear algebra operations.

Setting the following options will allow functions in 'svrep' to
use the 'torch' package to speed up certain computationally intensive
operations that occur when creating replicate weights, particularly
for Fay's generalized replication method or generalized bootstrap methods.

The option \code{svrep.torch_device} accepts the following options:
\itemize{
\item \code{options(svrep.torch_device = 'none')}: The 'torch' package will not be used.
\item \code{options(svrep.torch_device = 'cpu')}: The 'torch' package will be used
with all operations done on the CPU.
\item \code{options(svrep.torch_device = 'cuda')}: The 'torch' package will be used,
with operations conducted on the GPU if possible. This requires the user's
computer to have a CUDA-enabled GPU.
}

Note that precise values for matrix decompositions can vary between
different linear algebra libraries (including among common BLAS/LAPACK),
and so the replicate weights created with 'torch' may not exactly
match those created without 'torch'; differences will generally be small.

The following function from 'torch' will control
the number of threads used for computations, which can have a large
impact on speed.
\itemize{
\item \code{torch::set_num_threads()}: Sets the number of threads that 'torch' can use.
}
}

\section{Relevant options from the 'survey' package}{


The 'survey' package has the following options which are of particular relevance
to users of 'svrep'.
\itemize{
\item \code{options(survey.replicates.mse = TRUE/FALSE)}: The default value for this option
is \code{FALSE}. This option controls the default value used for the \code{mse} argument in
the functions \code{svrepdesign()} and \code{as.svrepdesign()}.
}

Call \code{help('survey.replicates.mse', package = 'survey')} for more details.

In nearly all cases, it is safer to use
\code{options(survey.replicates.mse = TRUE)}, or--better yet--
to always specify \code{svrepdesign(..., mse = TRUE)} or
\code{as.svrepdesign(..., mse = TRUE)} when using functions with an \code{mse} argument.

For replicate weights created using Fay's generalized replication method or
the generalized bootstrap, using \code{mse = FALSE} can result in badly biased
variance estimates.
\itemize{
\item \code{options(survey.multicore = TRUE/FALSE)}: The default value for this option
is \code{FALSE}. Setting this option to \code{TRUE} means that multiple processors
will be used for certain variance calculations involving replicate weights,
such as in \code{svyglm()}.
}

This can potentially speed up calculations but is not guaranteed to do so.

Call \code{help('survey.multicore', package = 'survey')} for more details.
}

