% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cox_summary.R
\name{get_cox_summary}
\alias{get_cox_summary}
\title{Summarizes the Cox Regression Analysis}
\usage{
get_cox_summary(cox.res, ci = 95)
}
\arguments{
\item{cox.res}{The result of a coxph fit.}

\item{ci}{The confidence interval to calculate.}
}
\value{
A data.frame that summarizes the results.
}
\description{
This function summarizes the results of a cox regression returning the
results in a data.frame. It will calculate the confidence interval.
}
\examples{
cox.res <- survival::coxph(survival::Surv(time,status) ~ rx, survival::colon)
get_cox_summary(cox.res)
}
