% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_km.R
\name{theme_km}
\alias{theme_km}
\title{Custom ggplot theme that make Kaplan-Meier curves look nice}
\usage{
theme_km(base_size = 11, base_family = "",
  base_line_size = base_size/22, base_rect_size = base_size/22)
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}

\item{base_line_size}{base size for line elements}

\item{base_rect_size}{base size for rect elements}
}
\description{
Custom theme, based upon the theme_bw theme in ggplot2
}
\examples{
library(survsup); library(ggplot2)
p <- ggplot(mtcars) + geom_point(aes(x = wt, y = mpg,
    colour = factor(gear))) + facet_wrap(~am)

p + theme_km()
}
