% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_functions.R
\name{hcl_rainbow}
\alias{hcl_rainbow}
\title{Convenience function for the rainbow_hcl color scheme}
\usage{
hcl_rainbow(g, reverse = FALSE, c = 50, l = 70, start = 0,
  end = 360 * (n - 1)/n)
}
\arguments{
\item{g}{ggplot object containing a Kaplan-Meier plot}

\item{reverse}{should the order of the colors be reversed?}

\item{c}{chroma}

\item{l}{luminance}

\item{start}{the hue at which the rainbow begins}

\item{end}{the hue at which the rainbow ends}
}
\value{
Returns a ggplot object
}
\description{
Convenience function to change the color scheme to
the rainbow_hcl scheme provided by the colorspace package.
The function will detect how many strata are available and
will pick that many colors from rainbow_hcl.
}
\examples{
library(survival)
library(dplyr)
veteran \%>\%
    survfit(Surv(time, status) ~ celltype, data = .) \%>\%
   plot_survfit(cuminc = FALSE) \%>\%
   hcl_rainbow()
}
\author{
Daniel Lindholm
}
