% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survregVB.frailty.fit.R
\name{survregVB.frailty.fit}
\alias{survregVB.frailty.fit}
\title{Variational Bayesian Analysis of Correlated Survival Data Using a
Log-Logistic Accelerated Failure Time Model}
\usage{
survregVB.frailty.fit(
  Y,
  X,
  alpha_0,
  omega_0,
  mu_0,
  v_0,
  lambda_0,
  eta_0,
  cluster,
  max_iteration = 100,
  threshold = 1e-04
)
}
\arguments{
\item{Y}{A \code{Surv} object containing 2 columns: time and event.}

\item{X}{A design matrix including covariates with first column of ones
to represent the intercept.}

\item{alpha_0}{The shape hyperparameter \eqn{\alpha_0} of the prior
distribution of the scale parameter, \emph{b}.}

\item{omega_0}{The shape hyperparameter \eqn{\omega_0} of the prior
distribution of the scale parameter, \emph{b}.}

\item{mu_0}{Hyperparameter \eqn{\mu_0}, a vector of means, of the prior
distribution of the vector of coefficients, \eqn{\beta}.}

\item{v_0}{The precision (inverse variance) hyperparameter \eqn{v_0},
of the prior distribution of the vector of coefficients, \eqn{\beta}.}

\item{lambda_0}{The shape hyperparameter \eqn{\lambda_0} of the prior
distribution of the frailty variance, \eqn{\sigma_\gamma^2}.}

\item{eta_0}{The scale hyperparameter \eqn{\eta_0} of the prior distribution
of the frailty variance, \eqn{\sigma_\gamma^2}.}

\item{cluster}{An optional variable which clusters the observations to
introduce shared frailty for correlated survival data.}

\item{max_iteration}{The maximum number of iterations for the variational
inference optimization. If reached, iteration stops. (Default:100)}

\item{threshold}{The convergence threshold for the evidence based lower
bound (ELBO) optimization. If the difference between the current and
previous ELBO's is smaller than this threshold, iteration stops.
(Default:0.0001)}
}
\value{
A list containing results of the fit.
}
\description{
Called by \code{survregVB} to do the actual parameter and ELBO computations
for correlated survival data with shared frailty (a random intercept).
This routine does no checking that the arguments are the proper length
or type.
}
\details{
Implements the Variational Bayes algorithm with random intercepts proposed
in the paper "Fast variational bayesian inference for correlated survival
data: An application to invasive mechanical ventilation duration analysis".

For right-censored survival time \eqn{T_{ij}} of the \eqn{j_{th}} subject
from the \eqn{i_{th}} cluster in the sample, in a sample, \eqn{i=1,...,K}
and \eqn{j=1,...,n_i}, the shared-frailty log-logistic AFT model is specified
as follows:

\eqn{\log(T_{ij})=\gamma_i+X_{ij}^T\beta+b\epsilon_{ij}}, where
\itemize{
\item \eqn{X_{ij}} is a column vector of length \eqn{p, p\ge2} containing
\eqn{p-1} covariates and a constant one to incorporate the intercept
(i.e., \eqn{X_i=(1,x_{ij1},...,x_{ij(p-1)})^T}),
\item \eqn{\beta} is the corresponding vector of coefficients for the fixed effects,
\item \eqn{\gamma_i} is a random intercept for the \eqn{i_{th}} cluster,
\item \eqn{\epsilon_{ij}} is a random variable following a standard logistic
distribution, and
\item \emph{b} is a scale parameter.
}
}
\examples{
fit <- survregVB.frailty.fit(
  X = matrix(c(rep(1, 75), simulation_frailty$x1, simulation_frailty$x2), nrow = 75),
  Y = survival::Surv(simulation_frailty$Time, simulation_frailty$delta),
  alpha_0 = 3,
  omega_0 = 2,
  mu_0 = c(0, 0, 0),
  v_0 = 0.1,
  lambda_0 = 3,
  eta_0 = 2,
  cluster = simulation_frailty$cluster
)

}
\references{
Xian, C., Souza, C. P. E. de, He, W., Rodrigues, F. F.,
& Tian, R. (2024). "Fast variational bayesian inference for correlated
survival data: An application to invasive mechanical ventilation
duration analysis." https://doi.org/10.48550/ARXIV.2408.00177
}
\seealso{
\code{\link{survregVB}}
}
