% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exponential_class.R
\name{s_exponential}
\alias{s_exponential}
\title{Factory of SURVIVAL objects with Exponential distributions}
\usage{
s_exponential(...)
}
\arguments{
\item{...}{Parameters to define the distribution. See the Parameters for details}
}
\value{
a SURVIVAL object of the exponential distribution family. See the
documentation of \code{s_factory} for the methods available for SURVIVAL objects
}
\description{
Creates a SURVIVAL object with an Exponential distribution.
}
\section{Parameters}{


To create an exponential survival object the following
options are available:

\emph{\code{lambda}} to specify the canonical parameter of the distribution, or

\emph{\code{surv}} and \emph{\code{t}} for the proportion surviving (no events) at time t, or

\emph{\code{fail}} and \emph{\code{t}} for the proportion failing (events) at time t

lambda = -log(surv)/t

lambda = -log(1-fail)/t

The parameters should be spell correctly as partial matching is not available
}

\examples{
s_exponential(lambda = 3)
s_exponential(surv = 0.4, t = 2)
s_exponential(fail = 0.6, t = 2)
}
