% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{fx_h_time}
\alias{fx_h_time}
\alias{dtom}
\alias{mtod}
\alias{dtoy}
\alias{ytod}
\alias{mtoy}
\alias{ytom}
\title{Functions to help in time conversion}
\usage{
dtom(x)

mtod(x)

dtoy(x)

ytod(x)

mtoy(x)

ytom(x)
}
\arguments{
\item{x}{the time to convert}
}
\value{
the converted time
}
\description{
This set of functions help in the time conversion, taking into account
generic times and not specific times. The conversions are based on the
assumption that 1 year is 365.25 days and is 12 months. There is no
adjustment for lap days or ours or difference of days between months
}
\section{Functions}{
\itemize{
\item \code{dtom()}: convert days to months

\item \code{mtod()}: convert months to days

\item \code{dtoy()}: convert days to years

\item \code{ytod()}: convert years to days

\item \code{mtoy()}: convert months to year

\item \code{ytom()}: convert years to months

}}
\examples{
dtom(365.25)
mtod(12)
dtoy(165.25)
ytod(1)
mtoy(12)
ytom(365.25)
}
