% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybrid.R
\name{HybridObj}
\alias{HybridObj}
\title{\code{HybridObj} (hybrid approach)}
\usage{
HybridObj(Alpha = NULL, Beta = NULL, Betastar = NULL, Delta = NULL,
  Xtrain = NULL, DifMat = NULL, Kernel = NULL, OptMeth = NULL,
  b0 = NULL)
}
\arguments{
\item{Alpha}{[\code{vector(1)}]\cr
A part of the solution of the quadratic optimization problem of interest.}

\item{Beta}{[\code{vector(1)}]\cr
A part of the solution of the quadratic optimization problem of interest.}

\item{Betastar}{[\code{vector(1)}]\cr
A part of the solution of the quadratic optimization problem of interest.}

\item{Delta}{[\code{vector(1)}]\cr
Vector of status 1 = no censored.}

\item{Xtrain}{[\code{matrix(1)}]\cr
Matrix of training data points.}

\item{DifMat}{[\code{\link{Diffmatrix}(1)}]\cr
Matrix used to maked differences between neighbor points.}

\item{Kernel}{[\code{\link{Kernel}(1)}]\cr
Object of class \code{Kernel}.}

\item{OptMeth}{[\code{\link{Kernel}(1)}]\cr
Program used to solve the optimization problem.}

\item{b0}{[\code{numeric(1)}]\cr
The estimated offset.}
}
\value{
[\code{HybridObj(1)}]
Object of class \code{Hybrid} containing elements:
\tabular{ll}{
   \code{Alpha} \tab Solution of the quadratic optimization problem, \cr
   \code{Xtrain} \tab Matrix of training points,\cr
   \code{DifMat} \tab Matrix used to made differences between neighbouring points. \cr
   \code{Kernel} \tab Kernel matrix, an object of class \code{Kernel},\cr
   \code{OptMeth} \tab Program used to solve the quadratic optimization problem.\cr
 }
}
\description{
Constructs object of class \code{VB2FitObj}.\cr
}
\keyword{internal}
