% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vanbelle2.R
\name{vanbelle2Fit}
\alias{vanbelle2Fit}
\title{survivalsvm (ranking approach)}
\usage{
vanbelle2Fit(X, Y, delta, meth_par = 1, kernel_type = "lin_kernel",
  kernel_pars = NA, bin_cat = integer(0), makediff = makediff3,
  opt_alg = "quadprog", sgf_sv = 5, sigf = 7, maxiter = 40,
  margin = 0.05, bound = 10, eig.tol = 1e-06, conv.tol = 1e-07,
  posd.tol = 1e-08)
}
\arguments{
\item{X}{[\code{matrix(1)}]\cr
Matrix of training data point.}

\item{Y}{[\code{vector(1)}]\cr
Vector of survival times.}

\item{delta}{[\code{vector(1)}]\cr
Vector of status: 1 = not censored.}

\item{meth_par}{[\code{numeric(1)}]\cr
Parameter of regularization.}

\item{kernel_type}{[\code{numeric(1)}]\cr
Kernel that will be used to fit the model. The handled type are: linear kern ('lin_kern'), additive kernel ('add_kernel'),
radial basis kernels ('rbf_kernel' and 'rbf4_kernel') and the polynomial kernel ('poly_kernel').}

\item{kernel_pars}{[\code{numeric(1)|vector(1)}]\cr
Parameters of kernel, when required.}

\item{bin_cat}{[\code{vector(1)}]\cr
Indexes of binary/categorical varibales}

\item{makediff}{[\code{character(1)}]\cr
String indicating which of \code{'makediff1'}, \code{'makediff2'} or \code{'makediff3'}
will be used.}

\item{opt_alg}{[\code{character}]\cr
Program that will be used to solve the quadratic optimization problem. Either \code{\link{quadprog}} or \code{\link{ipop}}.}

\item{sgf_sv}{[\code{integer(1)}]\cr
Number of decimal digits in the solution of the quadratic optimization problem.}

\item{sigf}{[\code{integer(1)}]\cr
Used by \code{\link{ipop}}. See \code{\link{ipop}} for details.}

\item{maxiter}{[\code{inter(1)}]\cr
Used by \code{\link{ipop}}. See \code{\link{ipop}} for details.}

\item{margin}{[\code{numeric(1)}]\cr
Used by \code{\link{ipop}}. See \code{\link{ipop}} for details.}

\item{bound}{[\code{numeric(1)}]\cr
Used by \code{\link{ipop}}. See \code{\link{ipop}} for details.}

\item{eig.tol}{[\code{numeric(1)}]\cr
Used by \code{nearPD} for adjusting positive definiteness. See \code{\link{nearPD}} for detail.}

\item{conv.tol}{[\code{numeric(1)}]\cr
Used by \code{nearPD} for adjusting positive definiteness. See \code{\link{nearPD}} for detail.}

\item{posd.tol}{[\code{numeric(1)}]\cr
Used by \code{nearPD} for adjusting positive definiteness. See \code{\link{nearPD}} for detail.}
}
\value{
[\code{VB2FitObj(1)}]
Object of class \code{VB2FitObj} containing elements:
\tabular{ll}{
   \code{Alpha} \tab solution of the quadratic optimization problem, \cr
   \code{Xtrain} \tab matrix of training points,\cr
   \code{DifMat} \tab matrix used to maked differences between neighbor points, \cr
   \code{Kernel} \tab kernel matrix, an object of class \code{Kernel},\cr
   \code{OptMeth} \tab program used to solve the quadratic optimization problem.\cr
 }
}
\description{
fits the 'vanbelle2' version of the ranking approach of survival support vector ananlysis.
}
\author{
Cesaire J. K. Fouodo
}
\keyword{internal}
