% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrapThresholds.R
\name{bootstrapThresholds}
\alias{bootstrapThresholds}
\title{Calculate per-separation point hazard ratio thresholds}
\usage{
bootstrapThresholds(bs_dfr, n_sd = 1.96)
}
\arguments{
\item{bs_dfr}{A matrix of bootstrapped hazard ratio computations as ordered
by a random measurement vector. Typically consisting of 5-10,000 repeat 
samplings}

\item{n_sd}{The number of standard deviations used to define threshold width.
95% of random hazard ratio values fall within the thresholds with a standard 
deviation of 1.96}
}
\value{
A dataframe of per-separation point mean, upper and lower thresholds
}
\description{
Calculate per-separation point hazard ratio thresholds
}
\examples{
data(nki_subset)
library(Biobase)
library(magrittr)
library(ggplot2)

#simulate example HR bootstrapped data
bs_dfr <- matrix(rnorm(150000), ncol = 1000, nrow = 150)

#calculate thresholds
thresholds <- bootstrapThresholds(bs_dfr)
}
