% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surveytable.R
\docType{package}
\name{surveytable-options}
\alias{surveytable-options}
\title{Package options}
\description{
This article is for more advanced users. Typical users, see \code{\link[=set_opts]{set_opts()}}
and \code{\link[=show_opts]{show_opts()}} to set and show certain options.
}
\details{
To view all available options, use \code{\link[=show_options]{show_options()}}. Below is a description
of some noteworthy options.
\subsection{Changing the number of decimal places or significant digits}{

By default, all estimates are rounded in a certain way. The user can change how the
rounding is performed.

The following options are the names of functions that control rounding:
\code{surveytable.tx_count} (for estimates of counts), \code{surveytable.tx_prct} (for estimates
of percentages), \code{surveytable.tx_rate} (for estimates of rates), and
\code{surveytable.tx_numeric} (for estimates of numeric variables). To turn off all
rounding, set each one of these options to \code{".tx_none"}.

Each function takes one argument, a \code{data.frame} with the following columns:
\code{x} (point estimates), \code{s} (standard errors), \code{ll} and \code{ul} (CI's).
Each function outputs a \code{data.frame} with the same column names. For examples of
how this works, see the internal functions \code{surveytable:::.tx_count_int} (counts,
rounded to the nearest integer), \code{surveytable:::.tx_count_1k} (counts, rounded
to the nearest one thousand), \code{surveytable:::.tx_prct} (percentages), \code{surveytable:::.tx_rate}
(rates), and \code{surveytable:::.tx_numeric} (numeric variables).

You can set the above options to your own custom functions. You might also want
to adjust the following options, which are the names of
columns in the printed tables: \code{surveytable.names_count} (by default, this
changes when rounding counts to the nearest one thousand) and \code{surveytable.names_prct}.
}

\subsection{Printing using various table-making packages}{

The tabulation functions return objects of class \code{surveytable_table} (for a single
table) or \code{surveytable_list} (for multiple tables, which is just a list of \code{surveytable_table}
objects). A \code{surveytable_table} object is just a \code{data.frame} with the following
attributes: \code{title}, \code{footer}, and \code{num}, which is the index of columns that
should be formatted as a number.

Naturally, these objects can be printed using a variety of packages. \code{surveytable}
ships with the ability to use \code{huxtable}, \code{gt}, or \code{kableExtra}. See the \code{output}
argument of \code{\link[=set_opts]{set_opts()}}.

You can supply custom code to use another table-making package or to use one of these
table-making packages, but in a different way. The two relevant options are \code{surveytable.output_object}
and \code{surveytable.output_print}.

\code{surveytable.output_object} is the name of a function with the following arguments:
\code{x} and \code{...}, where \code{x} is a \code{surveytable_table} object. This function returns
an object from a table-making package, for example, it returns a \code{gt} object. Be sure
that this package is installed.

\code{surveytable.output_print} is the name of a function with the following arguments:
\code{x} and \code{...}, where \code{x} is an object returned by the \code{surveytable.output_object}
function. The \code{surveytable.output_print} function prints this object.

For an example of how this works, see the internal functions \code{surveytable:::.as_object_huxtable}
and \code{surveytable:::.print_huxtable}.
}

\subsection{Low-precision estimates}{

Optionally, all of the tabulation functions can identify low-precision estimates.
Turn on this functionality using any of the following: \link{set_opts}(lpe = TRUE),
\link{set_opts}(mode = "nchs"), \link{set_survey}(*, mode = "nchs"), or \code{options(surveytable.find_lpe = TRUE)}.

By default, low-precision estimates are identified using National Center for
Health Statistics (NCHS) algorithms. However, this can be changed, as described
below.

Here is a description of the options related to the identification of low-precision
estimates.
\itemize{
\item \code{surveytable.find_lpe}: should the tabulation functions look for low-precision
estimates? You can change this directly with \code{options()} or with either \code{\link[=set_opts]{set_opts()}}
or \code{\link[=set_survey]{set_survey()}}.
\item \code{surveytable.lpe_n}, \code{surveytable.lpe_counts}, \code{surveytable.lpe_percents}: names
of 3 functions.
}

The argument for \code{surveytable.lpe_n} is a vector of the number of observations
for each level of the variable.

The argument for \code{surveytable.lpe_counts} is a data frame with count-related estimates.
Specifically, the data frame has the following variables:
\itemize{
\item \code{x}: point estimates of counts
\item \code{s}: SE
\item \code{ll}, \code{ul}: CI
\item \code{samp.size}: effective sample size
\item \code{counts}: actual sample size
\item \code{degf}: degrees of freedom
}

The argument for \code{surveytable.lpe_percents} is a data frame with percent-related
estimates. Specifically, the data frame has the following variables:
\itemize{
\item \code{Proportion}: point estimates of proportions (between \code{0} and \code{1})
\item \code{SE}: SE
\item \code{LL}, \code{UL}: CI
\item \verb{n numerator}: the number of observations for which the variable is \code{TRUE}
\item \verb{n denominator}: the total number of observations
}

Each of these functions must return a list with the following elements:
\itemize{
\item \code{id}: the name of the algorithm used, such as \code{"NCHS presentation standards"}
\item \code{flags}: a vector. For each level of the variable, short codes indicating the presence of
low-precision estimates.
\item \code{has.flag}: a vector of short codes that are present in \code{flags}.
\item \code{descriptions}: a named vector. The names must be the short codes, the values are
the longer descriptions.
}

For example, if a variable has 3 levels, \code{flags} might be \code{c("", "A1 A2", "")}. This
indicates that for the first and third level, nothing was found, whereas for the second
level, two different things were found, indicated by short codes \code{A1} and \code{A2}. In
this case, \code{has.flag = c("A1", "A2")}, \code{descriptions = c(A1 = "A1: something", A2 = "A2: something else")}.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://cdcgov.github.io/surveytable/}
  \item \url{https://github.com/CDCgov/surveytable}
}


Other options: 
\code{\link{set_opts}()},
\code{\link{set_survey}()},
\code{\link{show_options}()}
}
\author{
\strong{Maintainer}: Alex Strashny \email{alex.strashny@gmail.com} (\href{https://orcid.org/0000-0002-6408-7745}{ORCID})

}
\concept{options}
