% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_cross.R, R/tab_subset.R
\name{tab_cross}
\alias{tab_cross}
\alias{tab_subset}
\title{Tabulate subsets or interactions}
\usage{
tab_cross(
  vr,
  vrby,
  max_levels = getOption("surveytable.max_levels"),
  csv = getOption("surveytable.csv")
)

tab_subset(
  vr,
  vrby,
  lvls = c(),
  test = FALSE,
  alpha = 0.05,
  p_adjust = FALSE,
  drop_na = getOption("surveytable.drop_na"),
  max_levels = getOption("surveytable.max_levels"),
  csv = getOption("surveytable.csv")
)
}
\arguments{
\item{vr}{variable to tabulate}

\item{vrby}{use this variable to subset the survey}

\item{max_levels}{a categorical variable can have at most this many levels. Used to avoid printing huge tables.}

\item{csv}{name of a CSV file}

\item{lvls}{(optional) only show these levels of \code{vrby}}

\item{test}{perform hypothesis tests?}

\item{alpha}{significance level for tests}

\item{p_adjust}{adjust p-values for multiple comparisons?}

\item{drop_na}{drop missing values (\code{NA})? Categorical variables only.}
}
\value{
A list of tables or a single table.
}
\description{
Create subsets of the survey using one variable, and tabulate another
variable within each of the subsets. Interact two variables and tabulate.
}
\details{
\code{tab_subset} creates subsets using the levels of \code{vrby}, and tabulates
\code{vr} in each subset. Optionally, only use the \code{lvls} levels of \code{vrby}.
\code{vr} can be categorical (factor), logical, or numeric.

\code{tab_cross} crosses or interacts \code{vr} and \code{vrby} and tabulates the new
variable. Tables created using \code{tab_subset} and \code{tab_cross} have the same
counts but different percentages. With \code{tab_subset}, percentages within each
subset add up to 100\%. With \code{tab_cross}, percentages across the entire
population add up to 100\%. Also see \code{\link[=var_cross]{var_cross()}}.

\code{test = TRUE} performs a test of association between the two variables. Also
performs t-tests for all possible pairs of levels of \code{vr} and \code{vrby}.
}
\examples{
set_survey(namcs2019sv)

# For each SEX, tabulate AGER
tab_subset("AGER", "SEX")

# Same counts as tab_subset(), but different percentages.
tab_cross("AGER", "SEX")

# Numeric variables
tab_subset("NUMMED", "AGER")

# Hypothesis testing
tab_subset("NUMMED", "AGER", test = TRUE)
}
\seealso{
Other tables: 
\code{\link{tab}()},
\code{\link{tab_rate}()},
\code{\link{tab_subset_rate}()},
\code{\link{total}()},
\code{\link{total_rate}()}
}
\concept{tables}
