% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplechoice.R
\name{multi_summary}
\alias{multi_summary}
\title{Compute summary statistics for a multiple choice questions}
\usage{
multi_summary(
  dataset,
  question,
  group_by = NULL,
  subgroups_to_exclude = NULL,
  weights = NULL,
  na.rm
)
}
\arguments{
\item{dataset}{The input dataframe (or tibble) of survey questions}

\item{question}{The columns that contain each of the response options for a
question, can be selected by using \strong{tidyselect} semanatics or providing a
vector of column names or numbers}

\item{group_by}{Optional variable to group the analysis. If provided, the
frequencies and counts will be calculated within each subgroup.}

\item{subgroups_to_exclude}{Optional vector specifying subgroups to exclude
from the analysis.}

\item{weights}{Optional variable containing survey weights. If provided,
frequencies and counts will be weighted accordingly.}

\item{na.rm}{Logical indicating whether to remove NA values from \code{question}
before analysis.}
}
\value{
A data frame containing summary statistics, including frequencies,
for the specified question.
}
\description{
This function generates summary statistics, including frequencies, based on
the provided question. It allows for optional grouping and weighting of data.
}
\seealso{
Other multiple-choice questions: 
\code{\link{multi_freq}()},
\code{\link{multi_table}()}
}
\concept{multiple-choice questions}
